<?php
require('../../../php.files/classes/pdoDB.php');
require('../../../php.files/classes/kas-framework.php');
$kas_framework->safesession();
require(constant('tripple_return') . 'php.files/classes/students.php');
require(constant('tripple_return') . 'php.files/classes/generalVariables.php');
require(constant('tripple_return') . 'php.files/classes/result.php');
require(constant('tripple_return') . 'php.files/classes/attendance.php');
//making sure that the staff wont have a viewing problem because of the session set by the student
if (!isset($_GET['staff_byepass'])) {
	require(constant('tripple_return') . 'php.files/student_details.php');
}


function nextTermBegins($session, $term)
{
	global $dbh;
	$new_term = $term + 1;
	$new_year = $session;
	if ($term == 3) {
		$new_term = 1;
		$new_year = $session + 1;
	}
	$getNext = $dbh->prepare("SELECT resumption FROM grade_terms_days WHERE grade_terms_days_session = ? AND grade_terms_days_term = ?");
	$getNext->execute([$new_year, $new_term]);
	$getObj = $getNext->fetch(PDO::FETCH_OBJ);

	if ($getObj->resumption == '') {
		echo 'UNSPECIFIED';
	} else {
		$date = str_replace('/', '-', $getObj->resumption); //Twist to fit the Y-M-D format for string to time
		$dated = date('Y-m-d', strtotime($date));
		echo 'Next Term Begins <b>' . date('jS F Y', strtotime($dated)) . '</b>';
	}
}

extract($_POST);
if (!defined('PASS_MARK')) {
    define('PASS_MARK', 40);
}

//making sure that the file was not accessed by the url
if (!isset($_POST['byepass'])) {
	exit('Error 404: File Cannot be Accessed');
}

if ($kas_framework->strisEmpty(@$grade_taken) or $kas_framework->strisEmpty(@$grade_terms) or $kas_framework->strisEmpty(@$session)) {
	$kas_framework->showWarningCallout("Hey!!! Dont be in a Hurry. You have not Selected your Your Class, Year and Term. If you dont see anything above, then please be calm. No Result for you yet.");
} else {

	$stdObjQuery = "SELECT * FROM studentbio WHERE studentbio_id = '" . $__doncareStudentID . "' LIMIT 1";
	$db_stdObjQuery = $dbh->prepare($stdObjQuery);
	$db_stdObjQuery->execute();
	$get_rows = $db_stdObjQuery->rowCount();
	$stdObj = $db_stdObjQuery->fetch(PDO::FETCH_OBJ);
	$db_stdObjQuery = null;

	$deduce_year = $session; //gotten from the dynamic related form deducing the session.
	//$deduced_year_taken = @mysql_result($deduce_year, 0, 'year');
	$std_full_name = $kas_framework->getValue('title_desc', 'tbl_titles', 'title_id', $stdObj->studentbio_title) . ' ' . $stdObj->studentbio_lname . ' ' . $stdObj->studentbio_fname . ' ' . $stdObj->studentbio_mname;
	// Getting the grades domain 
	$grades_domain_id = $kas_framework->getValue('grades_domain', 'grades', 'grades_id', $grade_taken);
	//getting the charge for the student wallet result checking
	$charge = $kas_framework->getValue('term_result_fee', 'grades_domain', 'grades_domain_id', $grades_domain_id);

	//checking the initialization of the form masters and principals report initialization and also checking the check result level
	$form_comment = "SELECT * FROM std_report_cards WHERE student = '" . $__doncareStudentID . "'
										AND grade = '" . $grade_taken . "' AND term = '" . $grade_terms . "' AND session = '" . $deduce_year . "' LIMIT 1";
	$db_form_comment = $dbh->prepare($form_comment);
	$db_form_comment->execute();
	$get_rows_form_comment = $db_form_comment->rowCount();

	if ($get_rows_form_comment != 0) {
		$getCommentary = $db_form_comment->fetch(PDO::FETCH_OBJ);
		if (isset($_GET['staff_byepass'])) { //since the staff also views result from here, then they should byepass this blockage so that the student will not cry at last
			//just do nothing and byepass the whole billing and incremental stuff
		} else {
			//Lets check if the money on payment for result check is on first
			if ($kas_framework->app_config_setting('pay_result_checking')) {
				if ($getCommentary->check_result == 0) {
					include('view_result_payment.php');
					exit;
				} else {
					//If you want to implement a counter for the results
					//include ('view_result_counter_reset.php');
				}
			}
		}

	} else {
		$kas_framework->showDangerCallout('This result have not been Initialized. Please check again later or see the admin if otherwise');
		exit();
	}
	$db_form_comment = null;
?>


	<!-- Main content -->
	<section class="content keliv_printer">
		<!-- title row -->
		<div class="row">
			<div class="col-xs-12">
				<h2 class="page-header">
					<i class="fa fa-list-alt text-green"></i> Result Sheet					
					<small class="pull-right">Date: <?php print date('d/m/Y') ?></small>
				</h2>
			</div><!-- /.col -->
		</div>
		<!-- info row -->
		<div class="row main_header_wrap">
			<div class="col-sm-2 left_col">
				<center><address>
					<?php $kas_framework->displaySchoolLogo('90', 'circle', '5px'); ?>
				</address></center>
			</div><!-- /.col -->
			<div class="col-sm-8 center_of_excellence">
				<?php 
					$getSchoolInfo = $dbh->prepare("SELECT * FROM tbl_school_profile WHERE id = 1");
					$getSchoolInfo->execute();
					$schoolDetails = $getSchoolInfo->fetch(PDO::FETCH_OBJ);
					
					$getSubRom = $dbh->prepare("SELECT * FROM student_grade_year WHERE student_grade_year_grade = ? AND student_grade_year_student = ? AND student_grade_year_year = ?");
					$getSubRom->execute([ $grade_taken, $__doncareStudentID, $deduce_year ]);
						if ($getSubRom->rowCount() == 0) {
							$grade_room = 0;
						} else {
							$getRm = $getSubRom->fetch(PDO::FETCH_OBJ);
							$grade_room = $getRm->student_grade_year_class_room;
						}

				?>
				<center> <!--<span style="font-size: 12px; font-weight:900px">ENUGU STATE CATHOLIC EDUCATION COMISSION</span> <br /> -->
					<span style="font-size: 24px; font-weight:900px"><?= $schoolName = $kas_framework->getValue('school_name', 'tbl_config', 'id', 1) ?></span> <br />
					 <?php print $schoolDetails->adress. ', ' .$schoolDetails->state. ', '.$schoolDetails->country. ' <br />' ?>
						Class: <?= '<b>'.$kas_framework->userGradeClass($grade_room, $grade_taken). '. 
						' . $kas_framework->getValue('grade_terms_desc', 'grade_terms', 'grade_terms_id', $grade_terms). '. 
						' . $kas_framework->getValue('school_years_desc', 'school_years', 'school_years_id', $deduce_year) . '</b> Session. <br />
							Name: <b>'.$std_full_name .'</b> &nbsp;&nbsp;&nbsp;  Reg. Number: <b>'.$stdObj->studentbio_internalid. '</b>';
								
								if (SHOW_AGE_IN_RESULT == true) {
									echo ' &nbsp;&nbsp;&nbsp; Age: ';
									if ($stdObj->studentbio_dob == '//' or $stdObj->studentbio_dob == NULL or $stdObj->studentbio_dob == '') {
										echo 'N/A';
									} else {
										// Create a DateTime object by parsing the date with the specified format
										$birthDate = DateTime::createFromFormat('m/d/Y', $stdObj->studentbio_dob);
										$currentDate = new DateTime();
										$age = $currentDate->diff($birthDate);
		
										// Return the years part of the interval
										echo $age->y. ' Years.';
									}
								}
							
						?> 
				</center>
			</div><!-- /.col -->
			<div class="col-sm-2 right_col" style="margin:10px 0">
				<center><?php $dynamicimage = $kas_framework->imageDynamic($stdObj->studentbio_pictures, $stdObj->studentbio_gender, $kas_framework->url_root('pictures/'));
				print '<img src="' . $dynamicimage . '" class="" style="width:90px" alt="User Image" />'; ?></center>
			</div><!-- /.col -->
		</div><!-- /.row -->
		<!-- Table row -->
		<div class="row mt-5">
			<div class="col-xs-12 table-responsive">
				<table class="table table-striped">
					<thead>
						<tr>
							<th>S/N</th>
							<th>Subject Offered</th>
							<th><?= constant('_CA_1_'.$grades_domain_id) ?></th>
							<th><?= constant('_CA_2_'.$grades_domain_id) ?></th>
							<?php 
								if (constant('CA_TYPE_'.$grades_domain_id) >= 3) {
									echo '<th>'.constant('_CA_3_'.$grades_domain_id) .'</th>';		
								}
								if (constant('CA_TYPE_'.$grades_domain_id) >= 4) {
									echo '<th>'. constant('_CA_4_'.$grades_domain_id) .'</th>';
								}
							?>
							<th>Exam</th>
							<th>Total</th>
							<th>Peak</th>
							<th>Base</th>
							<th>Position</th>
							<?= ($grades_domain_id > 3)? '<th>Grade</th>': ''; //Meaning that only JSS and SS have Grades  ?>
							<th>Comment</th>
							<?php if ($kas_framework->app_config_setting('result_comment') == true) {
								print '<th>Teacher\'s Note</th>';
							}  ?>
						</tr>
					</thead>
					<tbody>

					<?php
						
						//grade_history_primary G, student_grade_year S WHERE S.student_grade_year_grade = G.level_taken AND S.student_grade_year_class_room = $user_student_grade_year_class_room_id
						$result_deduction = "SELECT * FROM grade_history_primary G, student_grade_year S WHERE G.year = S.student_grade_year_year AND S.student_grade_year_grade = G.level_taken AND S.student_grade_year_student = G.student AND S.student_grade_year_class_room = '" . $result->schoolRoomDeducer() . "'
				 					AND G.year = ".$session." AND G.level_taken = " . $grade_taken . " AND G.quarter = " . $grade_terms . " AND G.exam_type='1' AND G.student = " . $__doncareStudentID . " ORDER BY G.course_code";
						$db_result_deduction = $dbh->prepare($result_deduction);
						$db_result_deduction->execute();
						$get_rows_db_result_deduction = $db_result_deduction->rowCount();

						//checking if the result selection is valid
						if ($get_rows_db_result_deduction == 0) {
							$kas_framework->showDangerCallout('This Result selection is invalid. Please select the right Session, Term and Class to View Result. Result could not be displayed.');
							exit;
						}
						$sn = 0; /* initializing the serial */
						$total_sub_passed = 0; /* initializing the total subject passed */
						$overall_total = 0; /* initializing the overall total score*/
						$sum_total_score = 0;
						while ($viewResultOpp = $db_result_deduction->fetch(PDO::FETCH_OBJ)) {
							$sn = $sn + 1;
							$pageRoom = $viewResultOpp->room;
							$subject_deduction = $kas_framework->getValue('grade_subject_desc', 'grade_subjects', 'grade_subject_id', $viewResultOpp->course_code);
							$total_score = $viewResultOpp->ca_score1 + $viewResultOpp->ca_score2 + $viewResultOpp->ca_score3 + $viewResultOpp->ca_score4 + $viewResultOpp->exam_score;
							$overall_total = $overall_total + $total_score;

							/*************************************************** */
							include('position_subject_picker.php'); //for the position in class->deducing the paremeters from the query above ($viewResultOpp)

							$sum_total_score  = $sum_total_score + $total_score;

							print '<tr>
									<td>' . $sn . '</td>
									<td>' . $subject_deduction . '</td>
									<td>&nbsp;&nbsp;' . $viewResultOpp->ca_score1 . '</td>
									<td>&nbsp;&nbsp;' . $viewResultOpp->ca_score2 . '</td>';
									
									if (constant('CA_TYPE_'.$grades_domain_id) >= 3) {
										echo '<td>&nbsp;&nbsp;' . $viewResultOpp->ca_score3 . '</td>';		
									}
									if (constant('CA_TYPE_'.$grades_domain_id) >= 4) {
										echo '<td>&nbsp;&nbsp;' . $viewResultOpp->ca_score4 . '</td>';
									}									
									
									echo '<td>&nbsp;&nbsp;' . $viewResultOpp->exam_score . '</td>
									<td>&nbsp;&nbsp;<b>' . $total_score . '</b></td>
									<td>&nbsp;&nbsp;' . $peak_score . '</td>
									<td>&nbsp;&nbsp;' . $base_score . '</td>
									<td>&nbsp;&nbsp;' . $subject_position_in_class . '</td>';

							/* detecting the grade taken and picking the right result format */
							if ($grades_domain_id == 2 or $grades_domain_id == 1) {
								$gradingSystem = $result->commentNurseryX('all');
								print '<td>' . $result->commentNurseryX($total_score) . '</td>';
								if ($total_score > PASS_MARK) {
									$total_sub_passed = $total_sub_passed + 1;
								}
							} else if ($grades_domain_id == 3) {
								$gradingSystem = $result->commentPrimaryX('all');
								print '<td>' . $result->commentPrimaryX($total_score) . '</td>';
								if ($total_score > PASS_MARK) {
									$total_sub_passed = $total_sub_passed + 1;
								}
							} else if ($grades_domain_id == 4) {
								$gradingSystem = $result->gradeJuniorSecondaryX('all');
								print '<td><b>' . $result->gradeJuniorSecondaryX($total_score) . '</b></td>
												<td>' . $result->commentJuniorSecondaryX($total_score) . '</td>';
								if ($total_score > PASS_MARK) {
									$total_sub_passed = $total_sub_passed + 1;
								}
							} else if ($grades_domain_id == 5) {
								$gradingSystem = $result->gradeSeniorSecondaryX('all');
								print '<td><b>' . $result->gradeSeniorSecondaryX($total_score) . '</b></td>
												<td>' . $result->commentSeniorSecondaryX($total_score) . '</td>';
								if ($total_score > PASS_MARK) {
									$total_sub_passed = $total_sub_passed + 1;
								}
							}

							print ($kas_framework->app_config_setting('result_comment') == true) ? '<td>' . $viewResultOpp->notes . '</td>' : '';
							print '</tr>';
						}
						$db_result_deduction = null;
						?>
					</tbody>
				</table>
			</div><!-- /.col -->
		</div><!-- /.row -->

		<?php
		if ($getCommentary->c_form_teacher == '' or $getCommentary->c_principal == '') {
			$kas_framework->showDangerCallout('This Result is not Ready yet. Please Check Later... Principal and Form Master\'s comment not ready. You can\'t print out this result now.');
		}
		?>
		<div class="row">
			<!-- Other Comments -->
			<div class="col-md-4">
				<p style="font-size:12px; font-weight:500">Form Teacher's Comment</p>
				<p class="well well-sm no-shadow" style="margin-top: -3px;">
					<?php print @$getCommentary->c_form_teacher ?>
				</p>
				<?php $scHead = ($grades_domain_id == '1' or $grades_domain_id == '2') ? 'Head Teacher\'s' : 'Principal\'s'; ?>
				<p style="font-size:12px; font-weight:500"><?php print $scHead ?> Comment</p>
				<p class="well well-sm no-shadow" style="margin-top: -3px;">
					<?php print @$getCommentary->c_principal ?>
				</p>
				<p style="font-size:12px; font-weight:500">Resumption Information</p>
				<p class="well well-sm no-shadow" style="margin-top: -3px;">
					<?= nextTermBegins($deduce_year, $grade_terms); ?>
				</p>

				<div class="col-md-4 pull-left">
					<?php if ($grades_domain_id == '1' or $grades_domain_id == '2' or $grades_domain_id == '3') {
						print 'Head Master\'s Sign.<br />
						<img src="' . $kas_framework->url_root('files/signatures/head_masters_signature.jpg') . '" height="55px" />';
					} else {
						print 'Principal\'s Sign.<br />
						<img src="' . $kas_framework->url_root('files/signatures/principals_signature.jpg') . '" height="55px" />';
					} ?>
				</div>
			</div><!-- /.col -->

			<?php
			/*************************************************** */ 
			$sn = ($sn == '0') ? '1' : $sn; ?>

			<div class="col-md-4">
				<?php if (SHOW_COGNITIVE_DOMAIN_IN_RESULT == true) { ?>
					<p class="lead">Cognitive Domain</p>
					<div class="table-responsive">
						<table class="table">
							<tr>
								<th><?php print $kas_framework->getValue('value', 'cognitive_domain', 'id', '1') ?></th>
								<td><?php print $getCommentary->cog_1 ?>%</td>
							</tr>
							<tr>
								<th><?php print $kas_framework->getValue('value', 'cognitive_domain', 'id', '2') ?></th>
								<td><?php print $getCommentary->cog_2  ?>%</td>
							</tr>
							<tr>
								<th><?php print $kas_framework->getValue('value', 'cognitive_domain', 'id', '3') ?></th>
								<td><?php print $getCommentary->cog_3  ?>%</td>
							</tr>
							<tr>
								<th><?php print $kas_framework->getValue('value', 'cognitive_domain', 'id', '4') ?></th>
								<td><?php print $getCommentary->cog_4  ?>%</td>
							</tr>
							<tr>
								<th>Attendance:</th>
								<td><?php print $dtto->getAttendanceDigit($__doncareStudentID, $grade_terms, $deduce_year, $no_of_dys) . '%' ?></td>
							</tr>
						</table>
					</div>
				<?php } ?>
				 
				<!-- <p class="lead">-</p>
				<p> FEES FOR <b>JUNIOR CLASSES (JA - JZ) is: N55, 500</b> <br />
					FEES FOR <b>SENIOR CLASSES (SO - SJ) is: N58, 500</b>.</p>
				
				For <b>Payment of School Fees</b> <br />
				<p> Dial <b>*347*109*1*REG_NUMBER#</b> and follow the prompt.</p>
 
				<br />Happy Holidays! <br /> <?= $schoolName ?> -->
				
			</div><!-- /.col -->


			<div class="col-md-4">
				<p class="lead">Result Summary</p>
				<div class="table-responsive">
					<table class="table">
						<tr>
							<th>Total Score: </th>
							<td><?php echo $sum_total_score ?></td>
						</tr>
						<tr>
							<th> Personal Average: </th>
							<td><?php echo number_format(($sum_total_score / $sn), 2) ?></td>
						</tr>
						<tr>
							<th>Subject(s) Passed</th>
							<td><?php print $total_sub_passed . '/' . $sn; ?></td>
						</tr>
						
						<?php
								$subroom = $pageRoom;
								$classResult = getStudentPosition($subroom, $grade_terms);	
								if ($subroom != 0) {
									$overAll = getStudentPosition(0, $grade_terms);									
								}							

							?>
                           <tr>
							<th> Position in Class:</th>
							<td><?= getSuffixOfResult($classResult['position']). ' of '.$classResult['total_students'] ?></td>
						<tr>
						<?php if ($subroom != 0) { ?>
						<tr>
							<th> Position in <?= $kas_framework->getValue('grades_desc', 'grades', 'grades_id', $grade_taken) ?>:</th>
							<td><?= getSuffixOfResult($overAll['position']). ' of '.$overAll['total_students'] ?></td>
						</tr>
						<?php } ?>
						<tr>
							<th>Best in Class:</th>
							<td><?php print number_format($classResult['best_average'], 2) . '%' ?></td>
						</tr>
						 
						<tr>
							<th> Class Average: </th>
							<td><?php print $classResult['class_average'] ?> %</td>
						</tr>
					</table>
				</div>
			</div><!-- /.col -->
			<div class="col-md-12" style="border:1px solid #CCC; padding:6px; margin:10px; text-align:center">
				Grade Key:  <?php echo implode(', ', $gradingSystem); ?>
			</div>
		</div><!-- /.row -->
		<?php promotionStatus() ?>
			

		<!-- this row will not appear when printing -->
		<div class="row no-print">
			<?php if ($getCommentary->c_form_teacher != '' and $getCommentary->c_principal != '') {
				$_SESSION['secx'] = $kas_framework->generateRandomString(20);
				//$link = 'view_result_open?grade_taken='.$grade_taken.'&session='.$session.'&grade_terms='.$grade_terms.'&__doncareStudentID='.$__doncareStudentID.'&sec='.$_SESSION['secx']; ?>
				<div class="col-xs-12"> <!--  -->
					<a onclick="window.print();" target="_blank" class="btn btn-primary btn-lg pull-right"><i class="fa fa-print"></i> Print Result Sheet</a>
				</div>
			<?php } ?>
		</div>

	</section><!-- /.content -->
<?php	} ?>