<?php
require('../../../php.files/classes/pdoDB.php');
require('../../../php.files/classes/kas-framework.php');
$kas_framework->safesession();
require(constant('tripple_return') . 'php.files/classes/students.php');
require(constant('tripple_return') . 'php.files/classes/generalVariables.php');
require(constant('tripple_return') . 'php.files/classes/result.php');
require(constant('tripple_return') . 'php.files/classes/attendance.php');
//making sure that the staff wont have a viewing problem because of the session set by the student
if (!isset($_GET['staff_byepass'])) {
	require(constant('tripple_return') . 'php.files/student_details.php');
}

extract($_GET);

//Security Check for User
if ($sec != $_SESSION['secx']) {
	exit('Unauthorized Access! Access to print view Denied by Kastech Network Limited');
}

function nextTermBegins($session, $term)
{
	global $dbh;
	$new_term = $term + 1;
	$new_year = $session;
	if ($term == 3) {
		$new_term = 1;
		$new_year = $session + 1;
	}
	$getNext = $dbh->prepare("SELECT resumption FROM grade_terms_days WHERE grade_terms_days_session = ? AND grade_terms_days_term = ?");
	$getNext->execute([$new_year, $new_term]);
	$getObj = $getNext->fetch(PDO::FETCH_OBJ);

	if ($getObj->resumption == '') {
		return 'UNSPECIFIED';
	} else {
		$date = str_replace('/', '-', $getObj->resumption); //Twist to fit the Y-M-D format for string to time
		$dated = date('Y-m-d', strtotime($date));
		return 'Next Term Begins <b>' . date('jS F Y', strtotime($dated)) . '</b>';
	}
}

$stdObjQuery = "SELECT * FROM studentbio WHERE studentbio_id = '" . $__doncareStudentID . "' LIMIT 1";
$db_stdObjQuery = $dbh->prepare($stdObjQuery);
$db_stdObjQuery->execute();
$get_rows = $db_stdObjQuery->rowCount();
$stdObj = $db_stdObjQuery->fetch(PDO::FETCH_OBJ);
$db_stdObjQuery = null;

$deduce_year = $session; //gotten from the dynamic related form deducing the session.
//$deduced_year_taken = @mysql_result($deduce_year, 0, 'year');
$std_full_name = $kas_framework->getValue('title_desc', 'tbl_titles', 'title_id', $stdObj->studentbio_title) . ' ' . $stdObj->studentbio_lname . ' ' . $stdObj->studentbio_fname . ' ' . $stdObj->studentbio_mname;
// Getting the grades domain 
$grades_domain_id = $kas_framework->getValue('grades_domain', 'grades', 'grades_id', $grade_taken);
//getting the charge for the student wallet result checking
$charge = $kas_framework->getValue('term_result_fee', 'grades_domain', 'grades_domain_id', $grades_domain_id);

//checking the initialization of the form masters and principals report initialization and also checking the check result level
$form_comment = "SELECT * FROM std_report_cards WHERE student = '" . $__doncareStudentID . "'
										AND grade = '" . $grade_taken . "' AND term = '" . $grade_terms . "' AND session = '" . $deduce_year . "' LIMIT 1";
$db_form_comment = $dbh->prepare($form_comment);
$db_form_comment->execute();
$get_rows_form_comment = $db_form_comment->rowCount();

if ($get_rows_form_comment != 0) {
	$getCommentary = $db_form_comment->fetch(PDO::FETCH_OBJ);
	if (isset($_GET['staff_byepass'])) { //since the staff also views result from here, then they should byepass this blockage so that the student will not cry at last
		//just do nothing and byepass the whole billing and incremental stuff
	} else {
		//Lets check if the money on payment for result check is on first
		if ($kas_framework->app_config_setting('pay_result_checking')) {
			if ($getCommentary->check_result == 0) {
				include('view_result_payment.php');
				exit;
			} else {
				//If you want to implement a counter for the results
				//include ('view_result_counter_reset.php');
			}
		}
	}
} else {
	$kas_framework->showDangerCallout('This result have not been Initialized. Please check again later or see the admin if otherwise');
	exit();
}


$getSchoolInfo = $dbh->prepare("SELECT * FROM tbl_school_profile WHERE id = 1");
$getSchoolInfo->execute();
$schoolDetails = $getSchoolInfo->fetch(PDO::FETCH_OBJ);

$getSubRom = $dbh->prepare("SELECT * FROM student_grade_year WHERE student_grade_year_grade = ? AND student_grade_year_student = ? AND student_grade_year_year = ?");
$getSubRom->execute([$grade_taken, $__doncareStudentID, $deduce_year]);
if ($getSubRom->rowCount() == 0) {
	$grade_room = 0;
} else {
	$getRm = $getSubRom->fetch(PDO::FETCH_OBJ);
	$grade_room = $getRm->student_grade_year_class_room;
}

$schoolName = $kas_framework->getValue('school_name', 'tbl_config', 'id', 1);
$clasx = $kas_framework->userGradeClass($grade_room, $grade_taken);
$termx = $kas_framework->getValue('grade_terms_desc', 'grade_terms', 'grade_terms_id', $grade_terms);
$sessionx = $kas_framework->getValue('school_years_desc', 'school_years', 'school_years_id', $deduce_year);

$subroom = $result->schoolRoomDeducer();
$classResult = getStudentPosition($subroom, $grade_terms);
if ($subroom != 0) {
	$overAll = getStudentPosition(0, $grade_terms);
}

$db_form_comment = null;


?>

<!----------------- Customized HTML Form for Results ------------------------->

<!DOCTYPE html>
<html>

<head>
	<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
	<title>Result Sheet</title>
</head>
<style type="text/css">
	body {
		position: relative;
		/* Ensure body has a relative position */
	}

	body::before {
		content: "";
		position: absolute;
		top: 50%;
		left: 50%;
		transform: translate(-50%, -50%);
		opacity: 0.09;
		/* Adjust opacity for the desired effect */
		z-index: 0;
		white-space: nowrap;
		width: 500px;
		/* Adjust width as needed */
		height: 500px;
		/* Adjust height as needed */
		background: url('<?= $kas_framework->school_utility_image('logo') ?>') no-repeat center center;
		background-size: contain;
		/* Adjust background size to contain */
	}

	.rating {
		margin: 0 10px;
	}

	#wrap {
		width: 56%;
		height: auto;
		margin: auto;
		border-radius: 4px;
		border: 1px solid #CCC;
		padding: 2px;
		text-align: center;
		font-size: 18px;
	}

	@media print {
		#wrap {
			width: auto;
			/* This will remove the 90% width for print */
		}

		body::before {
			top: 40%;
		}
	}

	table {
		border-collapse: collapse;
		width: 100%;
		border: 1px solid #CCC;
	}

	th,
	td {
		border: 1px solid #CCC;
		padding: 0px;
		text-align: center;
	}

	tr:nth-child(even) {
		background-color: #f2f2f2;
	}

	tr:nth-child(odd) {
		background-color: white;
	}
</style>

<body>
	<div id="wrap">
		<?php

		echo '<table border="0" width="97%">';

		echo "<td><img alt='Principal' src='" . $kas_framework->school_utility_image('logo') . "' width = '80px' />
		</td><td>  <B style='font-size:19px'>" . strtoupper($schoolName) . "</B><BR>
				" . $schoolDetails->adress . ', ' . $schoolDetails->state . ', ' . $schoolDetails->country . "<BR>
				Class: <b>" . $clasx . '.  ' . $termx . '. ' . $sessionx . "</b> Session.<BR>
				NAME: <B>" . $std_full_name . "</B>. REG: <B> " . $stdObj->studentbio_internalid . "</B>
		</td><td><img alt='Principal' src='" . $kas_framework->imageDynamic($stdObj->studentbio_pictures, $stdObj->studentbio_gender, $kas_framework->url_root('pictures/')) . "' width = '80px' /></td> ";

		echo '</table>';

		echo '<center><table border="1" width="97%">';
		$sn = 0;
		?>
		<tr>
			<th>S/N</th>
			<th>Subject Offered</th>
			<th><?= constant('_CA_1_' . $grades_domain_id) ?></th>
			<th><?= constant('_CA_2_' . $grades_domain_id) ?></th>
			<?php
			if (constant('CA_TYPE_' . $grades_domain_id) >= 3) {
				echo '<th>' . constant('_CA_3_' . $grades_domain_id) . '</th>';
			}
			if (constant('CA_TYPE_' . $grades_domain_id) >= 4) {
				echo '<th>' . constant('_CA_4_' . $grades_domain_id) . '</th>';
			}
			?>
			<th>Exam</th>
			<th>Total</th>
			<th>Peak</th>
			<th>Base</th>
			<th>Position</th>
			<?= ($grades_domain_id > 3) ? '<th>Grade</th>' : ''; //Meaning that only JSS and SS have Grades  
			?>
			<!--<th>Comment</th>-->
			<?php if ($kas_framework->app_config_setting('result_comment') == true) {
				print '<th>Teacher\'s Note</th>';
			}  ?>
		</tr>
		<?php

		//grade_history_primary G, student_grade_year S WHERE S.student_grade_year_grade = G.level_taken AND S.student_grade_year_class_room = $user_student_grade_year_class_room_id
		$result_deduction = "SELECT * FROM grade_history_primary G, student_grade_year S WHERE G.year = S.student_grade_year_year AND S.student_grade_year_grade = G.level_taken AND S.student_grade_year_student = G.student AND S.student_grade_year_class_room = '" . $result->schoolRoomDeducer() . "'
		AND G.year = " . $session . " AND G.level_taken = " . $grade_taken . " AND G.quarter = " . $grade_terms . " AND G.exam_type='1' AND G.student = " . $__doncareStudentID . " ORDER BY G.course_code";
		$db_result_deduction = $dbh->prepare($result_deduction);
		$db_result_deduction->execute();
		$get_rows_db_result_deduction = $db_result_deduction->rowCount();

		//checking if the result selection is valid
		if ($get_rows_db_result_deduction == 0) {
			$kas_framework->showDangerCallout('This Result selection is invalid. Please select the right Session, Term and Class to View Result. Result could not be displayed.');
			exit;
		}
		$sn = 0; /* initializing the serial */
		$total_sub_passed = 0; /* initializing the total subject passed */
		$overall_total = 0; /* initializing the overall total score*/
		$sum_total_score = 0;
		while ($viewResultOpp = $db_result_deduction->fetch(PDO::FETCH_OBJ)) {
			$sn = $sn + 1;
			$subject_deduction = $kas_framework->getValue('grade_subject_desc', 'grade_subjects', 'grade_subject_id', $viewResultOpp->course_code);
			$total_score = $viewResultOpp->ca_score1 + $viewResultOpp->ca_score2 + $viewResultOpp->ca_score3 + $viewResultOpp->ca_score4 + $viewResultOpp->exam_score;
			$overall_total = $overall_total + $total_score;

			/*************************************************** */
			include('position_subject_picker.php'); //for the position in class->deducing the paremeters from the query above ($viewResultOpp)

			$sum_total_score  = $sum_total_score + $total_score;

			print '<tr>
					<td>' . $sn . '</td>
					<td>' . $subject_deduction . '</td>
					<td>&nbsp;&nbsp;' . $viewResultOpp->ca_score1 . '</td>
					<td>&nbsp;&nbsp;' . $viewResultOpp->ca_score2 . '</td>';

			if (constant('CA_TYPE_' . $grades_domain_id) >= 3) {
				echo '<td>&nbsp;&nbsp;' . $viewResultOpp->ca_score3 . '</td>';
			}
			if (constant('CA_TYPE_' . $grades_domain_id) >= 4) {
				echo '<td>&nbsp;&nbsp;' . $viewResultOpp->ca_score4 . '</td>';
			}

			echo '<td>&nbsp;&nbsp;' . $viewResultOpp->exam_score . '</td>
					<td>&nbsp;&nbsp;<b>' . $total_score . '</b></td>
					<td>&nbsp;&nbsp;' . $peak_score . '</td>
					<td>&nbsp;&nbsp;' . $base_score . '</td>
					<td>&nbsp;&nbsp;' . $subject_position_in_class . '</td>';

			/* detecting the grade taken and picking the right result format */
			if ($grades_domain_id == 2 or $grades_domain_id == 1) {
				$gradingSystem = $result->commentNurseryX('all');
				print '<td>' . $result->commentNurseryX($total_score) . '</td>';
				if ($total_score > PASS_MARK) {
					$total_sub_passed = $total_sub_passed + 1;
				}
			} else if ($grades_domain_id == 3) {
				$gradingSystem = $result->commentPrimaryX('all');
				print '<td>' . $result->commentPrimaryX($total_score) . '</td>';
				if ($total_score > PASS_MARK) {
					$total_sub_passed = $total_sub_passed + 1;
				}
			} else if ($grades_domain_id == 4) {
				$gradingSystem = $result->gradeJuniorSecondaryX('all');
				print '<td><b>' . $result->gradeJuniorSecondaryX($total_score) . '</b></td>
				   <td>' . $result->commentJuniorSecondaryX($total_score) . '</td>';
				if ($total_score > PASS_MARK) {
					$total_sub_passed = $total_sub_passed + 1;
				}
			} else if ($grades_domain_id == 5) {
				$gradingSystem = $result->gradeSeniorSecondaryX('all');
				print '<td><b>' . $result->gradeSeniorSecondaryX($total_score) . '</b></td>
				   <td>' . $result->commentSeniorSecondaryX($total_score) . '</td>';
				if ($total_score > PASS_MARK) {
					$total_sub_passed = $total_sub_passed + 1;
				}
			}

			//print ($kas_framework->app_config_setting('result_comment') == true) ? '<td>' . $viewResultOpp->notes . '</td>' : '';
			print '</tr>';
		}

		$db_result_deduction = null;

		echo '</table></center>';
		echo "<br>Grade Key:  " . implode(', ', $gradingSystem) . "<br>";

		echo '<table class="ratings">
        <thead>
            <tr>
                <th>AFFECTIVE RATING</th>
                <th>Score</th>
                <th>PHYSICAL RATING</th>
                <th>Score</th>
                <th>PSYCHOMOTOR RATING</th>
                <th>Score</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td>' . $kas_framework->getValue('value', 'cognitive_domain', 'id', '1') . '</td>
                <td>' . $getCommentary->cog_1 . '%</td>
                <td>Attendance</td>
                <td>' . $dtto->getAttendanceDigit($__doncareStudentID, $grade_terms, $deduce_year, $no_of_dys) . '</td>
                <td>Total Score</td>
                <td>' . $sum_total_score . '</td>
            </tr>
            <tr>
                <td>' . $kas_framework->getValue('value', 'cognitive_domain', 'id', '2') . '</td>
                <td>' . $getCommentary->cog_2 . '%</td>
                <td>' . $kas_framework->getValue('value', 'cognitive_domain', 'id', '3') . '</td>
                <td>' . $getCommentary->cog_3 . '%</td>
                <td>Personal Average</td>
                <td>' . number_format(($sum_total_score / $sn), 2) . '</td>
            </tr>
            <tr>
                <td>' . $kas_framework->getValue('value', 'cognitive_domain', 'id', '4') . '</td>
                <td>' . $getCommentary->cog_4 . '%</td>
                <td> </td>
                <td> </td>
                <td>Subject Passed</td>
                <td>' . $total_sub_passed . "/" . $sn . '</td>
            </tr>
            <tr>
                <td> </td>
                <td> </td>
                 <td> </td>
                <td> </td>
                <td>Position in Class</td>
                <td>' . getSuffixOfResult($classResult['position']) . ' of ' . $classResult['total_students'] . '</td>
            </tr>';
			 if ($subroom != 0) { ?>
				<tr>
				<td></td>
                <td></td>
                <td></td>
                <td></td>
					<td> Position in <?= $kas_framework->getValue('grades_desc', 'grades', 'grades_id', $grade_taken) ?>:</td>
					<td><?= getSuffixOfResult($overAll['position']). ' of '.$overAll['total_students'] ?></td>
				</tr>
				<?php } else { ?>
				<tr>
				<td></td>
                <td></td>
                <td></td>
                <td></td>
					<td>Best in Class:</td>
					<td><?php print number_format($classResult['best_average'], 2) . '%' ?></td>
				</tr>
				<?php }
			 echo '
            <tr>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td>Class Average</td>
                <td>' . $classResult['class_average'] . '</td>
            </tr> 
        </tbody>
    </table>';

		promotionStatus();

		echo "<center><br>";
		echo '<table>
				<tr>
					<td>Principal\'s Comment:</td>
					<td>'.$getCommentary->c_principal.'</td>
				</tr>
				<tr>
					<td>Form Teacher\'s Comment:</td>
					<td>'.$getCommentary->c_form_teacher.'</td>
				</tr>
				<tr>
					<td>Resumption Info</td>
					<td>'.nextTermBegins($deduce_year, $grade_terms).'</td>
				</tr>	
		</table> </center>';

		echo "<br><br> Happy Holidays From All of Us at " . $schoolName . "<br>
					<br>Principal's Signature<br>
					<img alt='Principal' src='" . $kas_framework->url_root('files/signatures/principals_signature.jpg') . "' width = '60px' />";
		echo '</div>';

		?>
	</div>
</body>
<script type="text/javascript">
	window.onload = function() {
		window.print();
	};
</script>

</html>